/******************************************************************************/
class SetString : BaseEvent
{
public:
            SetString();
   virtual ~SetString();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   UID m_StringUID;
   VarString* m_VarString;
   Str m_Value, m_OrigValue;
};
/******************************************************************************/
SetString::SetString() : BaseEvent(), m_VarString(null), m_Value(""), m_OrigValue("")                 
{
   
}
SetString::~SetString()
{
   
}
/******************************************************************************/
void SetString::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("VarStringUID")) m_StringUID = p.asID();
   if(Param *p = obj.findParam("String"))       m_Value     = p.asText();
   
   m_OrigValue = m_Value;
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void SetString::AfterCreate()
{
   // Find the correct VarString to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesString)
      if(variablesString[i].id() == m_StringUID)
         m_VarString = &variablesString[i]; 
   
   DEBUG_ASSERT(m_VarString != null, "SetString: String var not found in scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void SetString::CallTriggeredAction()
{
   /*
   if(m_LogDetailed)
   {
      LogN(S+"Start Trigger: Setting VarString (INFO: " + m_VarString->m_EditorInfo + " ) from: " + m_VarString->GetValue() + ", to: " + m_Value);
   }
   else if(m_LogOutput)
   {
      LogN(S+" Stop Trigger: Setting VarString (INFO: " + m_VarString->m_EditorInfo + " ) to: " + m_Value);
   }
*/   
   m_VarString->SetValue(m_Value);
}

// This method is called when the duration of the event has been reached
void SetString::StopTriggeredAction()
{/*
   if(m_LogDetailed)
   {
      LogN(S+" Stop Trigger: Setting VarString (INFO: " + m_VarString->m_EditorInfo + " ) from: " + m_VarString->GetValue() + ", to: " + m_OrigValue);
   }
   else if(m_LogOutput)
   {
      LogN(S+" Stop Trigger: Setting VarString (INFO: " + m_VarString->m_EditorInfo + " ) to: " + m_OrigValue);
   }*/
   
   // If m_Duration is not -1, the bool will be set back to its original value, after a while
   m_VarString->SetValue(m_OrigValue); 
}
/******************************************************************************/